//Lab 07: Design IMC controller for the Non-minimum Phase Delay system.

//scilab - 6.0.0
// Operating System : Windows 10, 64-bit

//------------------------------------------------------------------
close;
clc;
clear;
//------------------------------------------------------------------

//System transfer function without delay (delay introduced in zcos)
s=poly(0,'s');
num=0.5848*(-0.32*s+1);
den=0.18*s^2+0.87*s+1;

//model
num_m=0.5848*(-0.3549*s+1);
den_m=0.1858*s^2+0.8627*s+1;

// Response of the system with IMC Control
figure;
importXcosDiagram(".\Lab07_IMC_Model.xcos")
xcos_simulate(scs_m,4);
scs_m.props.context
plot(ye.time,ye.values(:,1),'thickness',2)
xlabel('t (sec.)','fontsize',2);
ylabel('y(t)','fontsize',2);
title("Response of the system with IMC controller.",'fontsize',4);
set(gca(),"grid",[1 1])
xset('font size',2)

exec .\figure_properties.sci; //custom script for setting figure properties

// Error in plant and model output.
figure;
plot(ye.time,ye.values(:,2),'thickness',2)
xlabel('t (sec.)','fontsize',2);
ylabel('e(t)','fontsize',2);
set(gca(),"grid",[1 1])
xset('font size',2)

title("Error in plant and model output.",'fontsize',4);
exec .\figure_properties.sci; //custom script for setting figure properties
